'use strict';
angular.module('genisis').service('source',
  function () {

    var _sources = [{
      id: null,
      name: 'None'
    }, {
      id: 3,
      name: 'Clinical Data'
    }, {
      id: 2,
      name: 'Genomic Data'
    }, {
      id: 1,
      name: 'Survey Data'
    }];

    /**
     * Return the name of the source given the id
     * @param int id the id number of the source
     * @return string source name for that id
     **/
    this.toName = function (id) {
      if (!id) {
        return 'None';
      }

      var source = this.find(id);
      return (source) ? source.name : 'None';
    };

    /**
     * Find a specific source in the list
     * @param int id the source id
     * @return Object|null
     **/
    this.find = function (id) {

      if (!id) {
        return null;
      }

      //make sure it's always an integer
      id = parseInt(id, 10);

      var src = null;

      angular.forEach(_sources, function (source) {
        if (source.id === id) {
          src = source;
        }
      });

      return src;
    };

    /**
     * Return the array of sources
     * @return Object[] sources array
     **/
    this.get = function () {
      return _sources;
    };
  }
);